<?php
/**
 * PHP File Reverse Proxy / Downloader
 * 
 * این اسکریپت فایل را از سرور مبدا خوانده و از طریق سرور جاری به کاربر تحویل می‌دهد.
 */

// 1. تنظیمات اولیه
// آدرس پایه سرور اصلی (بدون اسلش آخر)
$remoteBaseUrl = "https://s3.hakimeghor.sbs";

// نام پارامتری که مسیر فایل را می‌گیرد (مثلا dl.php?path=...)
$paramName = 'path';

// افزایش محدودیت زمانی اسکریپت برای فایل‌های بزرگ
set_time_limit(0);
ini_set('memory_limit', '512M'); // مقدار کافی برای بافر

// دریافت مسیر فایل از پارامتر URL
if (!isset($_GET[$paramName]) || empty($_GET[$paramName])) {
    die("Error: No file path specified.");
}

$filePath = $_GET[$paramName];

// تمیزکاری مسیر برای امنیت (جلوگیری از Directory Traversal)
// اگر می‌خواهید دقیقاً هر لینکی کار کند، می‌توانید این بخش را ساده‌تر کنید
$filePath = ltrim($filePath, '/'); 
$remoteFileUrl = $remoteBaseUrl . '/' . $filePath;

// کدگذاری فاصله‌ها در URL (اگر فایل اسپیس داشته باشد)
$remoteFileUrl = str_replace(" ", "%20", $remoteFileUrl);

// 2. آماده‌سازی هدرها برای ارسال به سرور اصلی
$requestHeaders = [
    "User-Agent: YourSite-Downloader/1.0",
];

// اگر کاربر درخواست Resume داد (Range Header)، آن را به سرور اصلی بفرست
if (isset($_SERVER['HTTP_RANGE'])) {
    $requestHeaders[] = "Range: " . $_SERVER['HTTP_RANGE'];
}

// تنظیمات کانتکست برای باز کردن استریم
$contextOptions = [
    "http" => [
        "method" => "GET",
        "header" => implode("\r\n", $requestHeaders),
        "follow_location" => 1, // دنبال کردن ریدایرکت‌ها
        "ignore_errors" => true // دریافت پاسخ حتی در صورت خطای 404 برای نمایش
    ],
    "ssl" => [
        "verify_peer" => false, // اگر SSL سرور مقصد مشکل دارد، این را false بگذارید
        "verify_peer_name" => false,
    ]
];

$context = stream_context_create($contextOptions);

// 3. باز کردن اتصال به سرور اصلی
$fp = fopen($remoteFileUrl, 'rb', false, $context);

if (!$fp) {
    header("HTTP/1.1 404 Not Found");
    die("Error: Could not connect to remote server.");
}

// 4. دریافت و پردازش هدرهای پاسخ از سرور اصلی
// متغیر $http_response_header به صورت خودکار توسط fopen پر می‌شود
$responseHeaders = $http_response_header;

// لیست هدرهایی که می‌خواهیم به کاربر منتقل کنیم
$forwardableHeaders = [
    'content-type',
    'content-length',
    'content-disposition',
    'accept-ranges',
    'content-range',
    'last-modified',
    'etag'
];

$httpCode = 200;

foreach ($responseHeaders as $header) {
    // استخراج کد وضعیت HTTP (مثلا 200 یا 206 یا 404)
    if (preg_match('#HTTP/\d\.\d (\d+)#', $header, $matches)) {
        $httpCode = intval($matches[1]);
        header($header); // ارسال کد وضعیت به مرورگر
        continue;
    }

    // جدا کردن نام و مقدار هدر
    $parts = explode(':', $header, 2);
    if (count($parts) == 2) {
        $key = strtolower(trim($parts[0]));
        $value = trim($parts[1]);

        if (in_array($key, $forwardableHeaders)) {
            header("$key: $value");
        }
    }
}

// اگر فایل پیدا نشد یا خطا داشتیم
if ($httpCode >= 400) {
    fpassthru($fp);
    fclose($fp);
    exit;
}

// 5. غیرفعال کردن بافر خروجی PHP برای استریم واقعی
// این کار باعث می‌شود به محض خواندن دیتا، به سمت کاربر فرستاده شود
if (ob_get_level()) ob_end_clean();

// 6. خواندن و ارسال فایل به صورت تکه تکه (Chunked)
while (!feof($fp)) {
    // خواندن 8 کیلوبایت در هر دور
    echo fread($fp, 1024 * 8);
    
    // فلاش کردن بافر سیستم به سمت کاربر
    flush();
}

fclose($fp);
exit;
